//
//  IZMSettingMgrHelper.h
//  ZoomSetting
//
//  Created by Lester.Gong on 2025/10/27.
//

#ifndef IZMSettingMgrHelper_h
#define IZMSettingMgrHelper_h

NS_ASSUME_NONNULL_BEGIN

@protocol IZMSettingMgrHelper <NSObject>

@optional
@property (nonatomic, assign) BOOL videoPreviewing;

- (void)onReceiveUpcomingMeetingReminder:(NSDictionary *)meetingInfo;
- (void)makeResponsibleWindowKeyAndOrderFront;
- (void)onIPPhoneConnectResult:(BOOL)success
                 isDissconnect:(BOOL)isDissconnect
                     needReset:(BOOL)needReset
                    deviceName:(NSString *)deviceName;
- (void)relayoutAutodialWindowController;
- (void)showUpgradeWindow:(NSWindow*)hostWindow;
- (void)trackUpgradingFromSettingWindow;
- (void)openReportWindow:(NSWindow*)hostWindow;

@end

NS_ASSUME_NONNULL_END

#ifndef ZMSharedSettingMgrHelper
#define ZMSharedSettingMgrHelper ZMSharedFor(IZMSettingMgrHelper)
#endif /* ZMSharedSettingMgrHelper */

#endif /* IZMSettingMgrHelper_h */
