//
//  ZMPSAudioStatusProtocol.h
//  ZoomSetting
//
//  Created by Michael Lin on 2024/1/15.
//

#ifndef ZMPSAudioStatusProtocol_h
#define ZMPSAudioStatusProtocol_h

#import <ZoomSetting/ZMPSObject.h>

typedef NS_ENUM(NSUInteger, ZMPSMCDeviceSpecialInfoType) {
    ZMPSMCDeviceSpecialInfoTypeNoInput,
    ZMPSMCDeviceSpecialInfoTypeMusicDetected,
    ZMPSMCDeviceSpecialInfoTypeMuteReminder,
};

@class ZMPSDevice;
@protocol ZMPSAudioStatusProtocol <NSObject>

@optional
- (void)psAudioDeviceSpecialInfoChange:(ZMPSMCDeviceSpecialInfoType)type;
- (void)psPoorQualityAlert;
- (void)psMicAudioLevelChanged:(NSUInteger)level;
- (void)psMicRecordVoiceDetection:(BOOL)hasVoice;
- (void)psPlayRecordSeriallyStopped:(ZMPSScene)scene;
- (void)psMicDeviceChanged;
- (void)psMicDeviceRemovedForCurrentDevice:(BOOL)isCurrentDevice;
- (void)psMicDeviceAdded:(ZMPSDevice *)device;
- (void)psMicMutedChanged;
- (void)psStereoMicRecordingChanged;
- (void)psOriginalSoundChanged;

@end

#endif /* ZMPSAudioStatusProtocol_h */
