//
//  ZMSettingMgr.h
//  ZoomSetting
//
//  Created by Huxley Yang on 2018/1/30.
//  Copyright © 2018 Zipow. All rights reserved.
//

#import <ZoomUnit/ZoomUnit-Swift.h>

NS_ASSUME_NONNULL_BEGIN

@class ZMSettingItemViewController;

@interface ZMSettingMgr : NSWindowController

@property (readonly) __kindof ZMSettingItemViewController *generalItem;
@property (readonly) __kindof ZMSettingItemViewController *virtualItem;
@property (readonly) __kindof ZMSettingItemViewController *audioItem;
@property (readonly) __kindof ZMSettingItemViewController *notificationItem;
@property (readonly) __kindof ZMSettingItemViewController *meetingItem;
@property (readonly) __kindof ZMSettingItemViewController *recordingItem;
@property (readonly) __kindof ZMSettingItemViewController *shareItem;
@property (readonly) __kindof ZMSettingItemViewController *phoneItem;
@property (readonly) __kindof ZMSettingItemViewController *chatItem;
@property (readonly) __kindof ZMSettingItemViewController *accessibilityItem;
@property (readonly) __kindof ZMSettingItemViewController *shortcutItem;
@property (readonly) __kindof ZMSettingItemViewController *statisticItem;
@property (readonly) __kindof ZMSettingItemViewController *accountItem;

+ (instancetype)shared;

- (void)reloadTabs;//Only reload if the window is visible
- (void)show;//If the window is visible, only showWindow: is called, else the general page is showed
- (void)showWithIdentifier:(NSString* _Nullable)identifier;
- (void)showWithIdentifier:(NSString* _Nullable)identifier
                deeplinkID:(NSString* _Nullable)deeplinkID;
- (void)close;

//Window
/// customize the window level of screen share window in current or next show.
/// Then will be reset to default window level after closing it.
/// - Parameter windowLevel: The screenshare window level, pass less than 0 will reset window level to default
- (void)setWindowLevel:(NSInteger)windowLevel;
- (BOOL)focusToSelectedResult;

@end

NS_ASSUME_NONNULL_END
