//
//  ZMEmojiUnicodeData.h
//  SaasBeePTUIModule
//
//  Created by likevin on 7/11/17.
//  Copyright © 2017 Zipow. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <zChatComponent/ZMEmojiModel.h>

#define FAVORITE_EMOJI_MAX_COUNT 16

extern NSString *FavoriteEmojiKey(ZMCustomEmojiSource source);
@class ZMEmojiUnicodeData;

@protocol ZMEmojiUnicodeDataDelegate <NSObject>
@optional
- (BOOL)canShowTWFlagEmoji;
- (ZMCustomEmojiSource)emojiSourceForEmojiUnicodeData:(ZMEmojiUnicodeData *)unicodeData;
- (BOOL)isCustomEmojiDisabledForEmojiUnicodeData:(ZMEmojiUnicodeData *)unicodeData;
@end

@interface ZMEmojiUnicodeData : NSObject

@property (nonatomic, retain, readonly) NSMutableArray<ZMEmojiModel *> *frequentArray;
@property (nonatomic, retain, readonly) NSMutableArray<ZMEmojiModel *> *frequentWithoutCustomEmojiArray;

//unicode emoji for more emoji infomation,pls refer to https://www.unicode.org/Public/17.0.0/emoji/emoji-test.txt
//In the website you can learn more about what're unqulified/mini-qulified/fully qulified emoji.

///fullUnicode2EmojiNameMap is emojis that allowed to show. But concidering unqulified/mini-qulified/fully qulified emoji,
///you should not use its map directly. use isEmojiAllowedToShow instead.
@property (nonatomic, strong) NSMutableDictionary<NSString *, NSString *> *fullUnicode2EmojiNameMap;
///unicode2EmojiNameMap is emojis that allowed to send. But concidering unqulified/mini-qulified/fully qulified emoji,
///you should not use its map directly. use isEmojiAllowedToSend instead.
@property (nonatomic, strong) NSMutableDictionary<NSString *, NSString *> *unicode2EmojiNameMap;
@property (nonatomic, strong) NSMutableDictionary<NSString *, NSString *> *emojiName2UnicodeMap;
@property (nonatomic, strong) NSMutableDictionary<NSString *, ZMEmojiModel *> *unicodeEmojiName2ModelMap;

@property (nonatomic, weak) id<ZMEmojiUnicodeDataDelegate> delegate;

- (void)initDataWithAllowedEmojis:(NSArray<NSString *> *)allowedEmojis;
- (BOOL)shouldShowCompactTab;
+ (NSArray *)skinToneEmojiArray;
- (ZMCustomEmojiSource)currentCustomEmojiSource;
- (NSArray *)categoryArrayWithCustomEmoji:(BOOL)withCustomEmoji;
- (void)scheduleSaveFavoriteEmojiList;
/// Get the selected emojis setting by admin
- (NSArray<ZMEmojiModel *> *)selectedEmojiStringArray;
- (BOOL)isEmojiAllowedInSelectedEmoji:(NSString *)emoji;
- (BOOL)isEmojiNameAllowedInSelectedEmoji:(NSString *)emoji;
- (NSMutableArray<ZMEmojiModel *> *)getFrequentMutableArray;
- (NSArray<ZMEmojiModel *> *)getLottieArray;
- (NSArray<ZMEmojiModel *> *)getEmojiArrayByCategory:(NSString*)category;
- (void)addFavorite:(ZMEmojiModel *)model;
- (void)removeFavoriteCustomEmojiWithFileID:(NSString *)fileID;
- (BOOL)contains1CharacterEmojiStr:(NSString *)emojiStr;
- (NSString *)tryReplaceCusEmojiWithSystemEmoji:(NSString *)emojiStr;
- (NSArray<ZMEmojiModel *> *)availableFrequentlyUsedEmojiWithCustomEmoji:(BOOL)withCustomEmoji;
- (void)cleanUp;

- (BOOL)isEmojiAllowedToShow:(NSString *)emoji;
- (BOOL)isEmojiAllowedToSend:(NSString *)emoji;

- (NSMutableArray<NSString *> *)convertToEmojiStringWithModelArray:(NSArray<ZMEmojiModel *> *)emojiModelArr;
- (NSMutableArray<ZMEmojiModel *> *)convertToModelWithEmojiStringArray:(NSArray<NSString *> *)emojiStrArr;

@end
