//**********************************************************************************************************************
//
//  BXAlert.h
//
//  Author:		Peter Baumgartner, peter@baumgartner.com
//  Copyright:	©2006-2011 by IMAGINE GbR. All rights reserved.
//	Abstract:	Subclass of NSAlert that adds a "Don't show again" checkbox
//
//**********************************************************************************************************************


#pragma mark CONSTANTS

extern NSString* BXAlertDelayedAlertHasClosed;


//----------------------------------------------------------------------------------------------------------------------


#pragma mark

@interface BXAlert : NSAlert
{
    NSString* _identifier;
}

// Structor...

+ (BXAlert*) alertWithMessageText:(NSString*)message 
             defaultButton:(NSString*)defaultButton 
             alternateButton:(NSString*)alternateButton 
             otherButton:(NSString*)otherButton 
             informativeTextWithFormat:(NSString*)format, ...;

// Add a checkbox...

@property (retain) NSString* identifier;

// Restore prefs to virgin state...

+ (void) removePrefsKeyForIdentifier:(NSString*)inIdentifier;
+ (void) removeAllPrefsKeys;

// Delayed alert. The delegate reply selector method should have the signature:
// - (void) alertWasClosed:(BXAlert*)inAlert withButton:(NSInteger)inButton;

- (void) runModalWithDelay:(double)inDelay replyTarget:(id)inTarget replySelector:(SEL)inSelector;
+ (BOOL) isDelayedAlertPending;

@end


//----------------------------------------------------------------------------------------------------------------------
