/*
	Owner:		Nicholas Shanks <nicholas@boinx.com>
	Company:	Boinx Software, Germany
	Abstract:	Draws an NSTextFieldCell with a shadow underneath.
	Related:	BXEmbossedTextField
*/

@interface BXEmbossedTextFieldCell : NSTextFieldCell
{
	NSColor *_shadowColor;
	BOOL _prefersLightShadow;					// uses +[NSColor highlightColor] for grey text; use on dark backgrounds
	BOOL _drawsShadowWhenDisabled;				// disabled text fields have a shadow too (default is no shadow)
	BOOL _usesHalfAlphaWhenDisabled;			// use textColor with 50% alpha for disabled text, instead of +disabledControlTextColor; use for mid-grey backgrounds
	BOOL _overridesForegroundColorAttributes;	// this overrides all forgroundcolor attributes of the title with textColor
}
- (BOOL)prefersLightShadow;
- (void)setPrefersLightShadow:(BOOL)flag;
- (BOOL)drawsShadowWhenDisabled;
- (void)setDrawsShadowWhenDisabled:(BOOL)flag;
- (BOOL)usesHalfAlphaWhenDisabled;
- (void)setUsesHalfAlphaWhenDisabled:(BOOL)flag;
- (BOOL)overridesForegroundColorAttributes;
- (void)setOverridesForegroundColorAttributes:(BOOL)flag;

- (NSColor *)shadowColor;
- (void)setShadowColor:(NSColor *)inColor;
- (NSColor *)shadowColorForTextColor:(NSColor *)inColor;

@end
