//**********************************************************************************************************************
//
//  BXGradientTableHeaderCell.h
//
//  Author:		Peter Baumgartner, peter@baumgartner.com
//  Copyright:	©2009-2011 by IMAGINE GbR. All rights reserved.
//	Abstract:	Custom header cell for table view that draws a gradient.
//
//**********************************************************************************************************************


@interface BXGradientTableHeaderCell : NSTableHeaderCell
{
	NSTableView* _tableView;
	NSGradient *_normalGradient;
	NSGradient *_pushedGradient;
	NSColor* _dividerColor;
}

@property (assign) NSTableView* tableView;
@property (retain) NSGradient *normalGradient;
@property (retain) NSGradient *pushedGradient;
@property (retain) NSColor* dividerColor;

+ (void) setHeaderCellsForTableView:(NSTableView *)inTableView;
- (void) initThemeForView:(NSView *)inView;
	
@end


//----------------------------------------------------------------------------------------------------------------------


@interface BXGradientTableCornerView : NSView
{
	BXGradientTableHeaderCell* _cell;
}

+ (BXGradientTableCornerView*) cornerView;
- (Class) cellClass;
@property (retain) BXGradientTableHeaderCell* cell;

@end


//----------------------------------------------------------------------------------------------------------------------
