//
//  BXDispatchToMainIfNeeded.h
//  BXFoundation
//
//  Created by Stefan Fochler on 23.05.18.
//  Copyright © 2018 Boinx Software Ltd. All rights reserved.
//

#import <Foundation/Foundation.h>

/**
 Dispatch a block to the main queue if not already running there without blocking the executing thread.
 */
void dispatch_async_to_main_if_needed(dispatch_block_t block);

/**
 Dispatch a block to the main queue if not already running there, waiting for its completion.
 
 Note that this is pretty dangerous and should only be used if async dispatch is not an option and the caller is pretty
 sure that the main thread is not already blocked by waiting for the caller (otherwise we have a deadlock!).
 */
void dangerously_dispatch_sync_to_main_if_needed(dispatch_block_t block);
