//
//  NSURL+UIPGenericResourceValue.h
//  Plus
//
//  Created by Maximilian Christ on 9/28/11.
//  Copyright (c) 2011 mczonk.de. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface NSURL (GenericResourceValue)

/**
 * @see NSURLIsRegularFileKey
 */
- (BOOL)isRegularFile;

/**
 * @see NSURLIsDirectoryKey
 */
- (BOOL)isDirectory;

/**
 * @see NSURLIsSymbolicLinkKey
 */
- (BOOL)isSymbolicLink;

/**
 * @see NSURLIsVolumeKey
 */
- (BOOL)isVolume;

/**
 * @see NSURLIsPackageKey
 */
- (BOOL)isPackage;

/**
 * @see NSURLIsHiddenKey
 */
- (BOOL)isHidden;

/**
 * @see NSURLHasHiddenExtensionKey
 */
- (BOOL)isExtensionHidden;

/**
 * @see NSURLCreationDateKey
 */
- (NSDate *)creationDate;

/**
 * @see NSURLContentModificationDateKey
 */
- (NSDate *)modificationDate;

/**
 * @see NSURLParentDirectoryURLKey
 */
- (NSURL *)parentDirectoryURL;

/**
 * @see NSURLVolumeURLKey
 */
- (NSURL *)volumeURL;

/**
 * @see NSURLTypeIdentifierKey
 */
- (NSString *)typeIdentifier;

/**
 * @see NSURLVolumeIdentifierKey
 */
- (id<NSCopying, NSCoding, NSObject>)volumeIdentifier;

/**
 * @see NSURLIsReadableKey
 */
- (BOOL)isReadable;

/**
 * @see NSURLIsWritableKey
 */
- (BOOL)isWriteable;

/**
 * @see NSURLIsExecutableKey
 */
- (BOOL)isExecutable;

/**
 * @see NSURLVolumeSupportsHardLinksKey
 */
- (BOOL)volumeSupportsHardlinks;

/**
 * @see NSTemporaryDirectory()
 */
+ (NSURL *)temporaryDirectoryURL;

#if 0
- (NSURL *)temporaryDirectoryURLOnSameVolume; // TODO
#endif

@end
