#  Permissions

## Usage:
```
var permissions = [
    BXPermissionViewModel(permission: .camera, image: i, isRequired: false),
    BXPermissionViewModel(permission: .microphone, image: i, isRequired: false),
    BXPermissionViewModel(permission: .screenRecording, image: i, isRequired: false),
    BXPermissionViewModel(permission: .accessibility, image: i, isRequired: false),
    BXPermissionViewModel(permission: .contacts, image: i, isRequired: false)
]

if #available(OSX 10.15, *) {
    permissions.append(BXPermissionViewModel(permission: .inputMonitoring, image: i, isRequired: false))
} else {
    // Fallback on earlier versions
}

let vc = BXPermissionsTableViewController(permissions: permissions)
windowController.contentViewController = vc
windowController.window?.setContentSize(vc.view.frame.size)
windowController.window?.contentView = vc.view
// windowController.window?.delegate = vc
windowController.showWindow(self)

```

## General Access
Docu:
https://developer.apple.com/documentation/bundleresources/information_property_list/protected_resources

### Camera Access
Docu:
https://developer.apple.com/documentation/avfoundation/cameras_and_media_capture/requesting_authorization_for_media_capture_on_macos

Requirements:
1) Info.plist entry:
NSCameraUsageDescription
2) Entitlements entry

Versioning:
1) Before macOS 10.14
2) macOS 10.14 and later

### Microphone Access
Docu:
https://developer.apple.com/documentation/avfoundation/cameras_and_media_capture/requesting_authorization_for_media_capture_on_macos

Requirements:
1) Info.plist entry:
NSMicrophoneUsageDescription
2) Entitlements entry

Versioning:
1) Before macOS 10.14
2) macOS 10.14 and later

### Contacts Access
Docu:
https://developer.apple.com/documentation/contacts/requesting_authorization_to_access_contacts

Requirements:
1) Info.plist entry:
NSContactsUsageDescription
2) Entitlements entry

Versioning:
None.

### Accessibility
Docu:
https://developer.apple.com/videos/play/wwdc2019/701/
https://developer.apple.com/documentation/iokit/iohidrequesttype/kiohidrequesttypepostevent?language=objc

Requirements:
None.

Versioning:
1) Before macOS 10.15
2) Afet macOS 10.15

### Input Monitoring
Docu: 
https://developer.apple.com/documentation/bundleresources/information_property_list/nsappleeventsusagedescription
https://developer.apple.com/documentation/iokit/iohidrequesttype/kiohidrequesttypelistenevent

Requirements:
1) Info.plist entry:
NSAppleEventsUsageDescription

Versioning:
1) Before macOS 10.15
2) Afet macOS 10.15

### ScreenCapture
Docu: 
https://developer.apple.com/documentation/avfoundation/avcapturescreeninput

Requirements:
None.

Versioning:
1) Before macOS 10.15
2) Afet macOS 10.15

## Learning

Best SO system preferences answer so far:
https://stackoverflow.com/questions/6652598/cocoa-button-opens-a-system-preference-page

## Preference pane keys list

Accessibility Preference Pane
Main    x-apple.systempreferences:com.apple.preference.universalaccess
Display x-apple.systempreferences:com.apple.preference.universalaccess?Seeing_Display
Zoom    x-apple.systempreferences:com.apple.preference.universalaccess?Seeing_Zoom
VoiceOver   x-apple.systempreferences:com.apple.preference.universalaccess?Seeing_VoiceOver
Descriptions    x-apple.systempreferences:com.apple.preference.universalaccess?Media_Descriptions
Captions    x-apple.systempreferences:com.apple.preference.universalaccess?Captioning
Audio   x-apple.systempreferences:com.apple.preference.universalaccess?Hearing
Keyboard    x-apple.systempreferences:com.apple.preference.universalaccess?Keyboard
Mouse & Trackpad    x-apple.systempreferences:com.apple.preference.universalaccess?Mouse
Switch Control  x-apple.systempreferences:com.apple.preference.universalaccess?Switch
Dictation   x-apple.systempreferences:com.apple.preference.universalaccess?SpeakableItems

Security & Privacy Preference Pane
Main    x-apple.systempreferences:com.apple.preference.security
General x-apple.systempreferences:com.apple.preference.security?General
FileVault   x-apple.systempreferences:com.apple.preference.security?FDE
Firewall    x-apple.systempreferences:com.apple.preference.security?Firewall
Advanced    x-apple.systempreferences:com.apple.preference.security?Advanced
Privacy x-apple.systempreferences:com.apple.preference.security?Privacy
Privacy-Camera x-apple.systempreferences:com.apple.preference.security?Privacy_Camera
Privacy-Microphone  x-apple.systempreferences:com.apple.preference.security?Privacy_Microphone
Privacy-Automation  x-apple.systempreferences:com.apple.preference.security?Privacy_Automation
Privacy-AllFiles    x-apple.systempreferences:com.apple.preference.security?Privacy_AllFiles
Privacy-Accessibility   x-apple.systempreferences:com.apple.preference.security?Privacy_Accessibility
Privacy-Assistive   x-apple.systempreferences:com.apple.preference.security?Privacy_Assistive
Privacy-Location Services   x-apple.systempreferences:com.apple.preference.security?Privacy_LocationServices
Privacy-SystemServices  x-apple.systempreferences:com.apple.preference.security?Privacy_SystemServices
Privacy-Advertising x-apple.systempreferences:com.apple.preference.security?Privacy_Advertising
Privacy-Contacts    x-apple.systempreferences:com.apple.preference.security?Privacy_Contacts
Privacy-Diagnostics & Usage x-apple.systempreferences:com.apple.preference.security?Privacy_Diagnostics
Privacy-Calendars   x-apple.systempreferences:com.apple.preference.security?Privacy_Calendars
Privacy-Reminders   x-apple.systempreferences:com.apple.preference.security?Privacy_Reminders
Privacy-Facebook    x-apple.systempreferences:com.apple.preference.security?Privacy_Facebook
Privacy-LinkedIn    x-apple.systempreferences:com.apple.preference.security?Privacy_LinkedIn
Privacy-Twitter x-apple.systempreferences:com.apple.preference.security?Privacy_Twitter
Privacy-Weibo   x-apple.systempreferences:com.apple.preference.security?Privacy_Weibo
Privacy-Tencent Weibo   x-apple.systempreferences:com.apple.preference.security?Privacy_TencentWeibo

macOS Catalina 10.15:
Privacy-ScreenCapture   x-apple.systempreferences:com.apple.preference.security?Privacy_ScreenCapture
Privacy-DevTools    x-apple.systempreferences:com.apple.preference.security?Privacy_DevTools
Privacy-InputMonitoring x-apple.systempreferences:com.apple.preference.security?Privacy_ListenEvent
Privacy-DesktopFolder   x-apple.systempreferences:com.apple.preference.security?Privacy_DesktopFolder
Privacy-DocumentsFolder x-apple.systempreferences:com.apple.preference.security?Privacy_DocumentsFolder
Privacy-DownloadsFolder x-apple.systempreferences:com.apple.preference.security?Privacy_DownloadsFolder
Privacy-NetworkVolume   x-apple.systempreferences:com.apple.preference.security?Privacy_NetworkVolume
Privacy-RemovableVolume x-apple.systempreferences:com.apple.preference.security?Privacy_RemovableVolume
Privacy-SpeechRecognition   x-apple.systempreferences:com.apple.preference.security?Privacy_SpeechRecognition
Privacy-DevTools    x-apple.systempreferences:com.apple.preference.security?Privacy_DevTools

macOS Big Sur 10.11/10.16:
Privacy-Bluetooth   x-apple.systempreferences:com.apple.preference.security?Privacy_Bluetooth
Privacy-Music   x-apple.systempreferences:com.apple.preference.security?Privacy_Media
Privacy-Home    x-apple.systempreferences:com.apple.preference.security?Privacy_HomeKit


Dictation & Speech Preference Pane
Dictation   x-apple.systempreferences:com.apple.preference.speech?Dictation
Text to Speech  x-apple.systempreferences:com.apple.preference.speech?TTS
Sharing Preference Pane
Main    x-apple.systempreferences:com.apple.preferences.sharing
Screen Sharing  x-apple.systempreferences:com.apple.preferences.sharing?Services_ScreenSharing
File Sharing    x-apple.systempreferences:com.apple.preferences.sharing?Services_PersonalFileSharing
Printer Sharing x-apple.systempreferences:com.apple.preferences.sharing?Services_PrinterSharing
Remote Login    x-apple.systempreferences:com.apple.preferences.sharing?Services_RemoteLogin
Remote Management   x-apple.systempreferences:com.apple.preferences.sharing?Services_ARDService
Remote Apple Events x-apple.systempreferences:com.apple.preferences.sharing?Services_RemoteAppleEvent
Internet Sharing    x-apple.systempreferences:com.apple.preferences.sharing?Internet
Bluetooth Sharing   x-apple.systempreferences:com.apple.preferences.sharing?Services_BluetoothSharing

Software update x-apple.systempreferences:com.apple.preferences.softwareupdate?client=softwareupdateapp


